/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	pgpDriverNT.h - PGP NT kernel mode device driver header file


	$Id: pgpDriverNT.h,v 1.4 2000/03/02 15:10:32 pbj Exp $
____________________________________________________________________________*/

#ifndef	_pgpDriverNT_h
#define _pgpDriverNT_h

#include "pgpCache.h"
#include "pgpInactivity.h"
#include "pgpMemlockNT.h"

#define MOUSE_SKIP				64
#define KEYBOARD_SKIP			16

#define MOUSE_DEVICE_NAME		L"\\Device\\PointerClass0"
#define KBD_DEVICE_NAME			L"\\Device\\KeyboardClass0"

#define	PGPUTIL_DEV				0x0000
#define KBD_ENTROPY_DEV			0x0001
#define MOUSE_ENTROPY_DEV		0x0002
#define WIPE_DELETE_DEV			0x0003


//	NT-specific critical section structure
typedef struct {
	KSPIN_LOCK		spinlock;
	KIRQL			irql;
	FAST_MUTEX		mutex;
} PGPDRIVERCRITICALSECTION, *PPGPDRIVERCRITICALSECTION;

//	driver object extension data structure
typedef struct {
	PDEVICE_OBJECT				pgpUtilDevo;
	ULONG						ulStatusFlags;

	PGPDRIVERCRITICALSECTION	csInactivity;
	PGPDRIVERCRITICALSECTION	csCache;
	PGPDRIVERCRITICALSECTION	csEntropy;
	PGPDRIVERCRITICALSECTION	csMemlock;

	PGPINACTIVITY				inactivity;
	PGPCACHE					cacheSign;
	PGPCACHE					cacheDecrypt;
	PGPMEMLOCK					memlock;
} DRVEXTENSION, *PDRVEXTENSION;

//	device object extension data structure
typedef struct {
	ULONG					ulDeviceType;
	PDRVEXTENSION			pdrve;
	PDEVICE_OBJECT			pdevoNext;
	ULONG					ulSkipCount;
	UCHAR					ucLogicalDrive;
	BOOLEAN					bIsNTFS;
	BOOLEAN					bIsAnsi;
} DEVEXTENSION, *PDEVEXTENSION;


// macros
//	DbgPrint prints a message to the kernel debugging console
#if PGP_DEBUG
#define PGPdbgPrint(arg) DbgPrint arg
#else
#define PGPdbgPrint(arg)
#endif

#if PGP_DEBUG && PGP_DEBUG_VERBOSE
#define PGPdbgVerbosePrint(arg)  DbgPrint arg
#else
#define PGPdbgVerbosePrint(arg)
#endif

#if	(_WIN32_WINNT < 0x0500)

#define IoSkipCurrentIrpStackLocation( Irp ) \
    (Irp)->CurrentLocation++; \
    (Irp)->Tail.Overlay.CurrentStackLocation++;

#define IoCopyCurrentIrpStackLocationToNext( Irp ) { \
    PIO_STACK_LOCATION irpSp; \
    PIO_STACK_LOCATION nextIrpSp; \
    irpSp = IoGetCurrentIrpStackLocation( (Irp) ); \
    nextIrpSp = IoGetNextIrpStackLocation( (Irp) ); \
    RtlCopyMemory( nextIrpSp, irpSp, FIELD_OFFSET(IO_STACK_LOCATION, CompletionRoutine)); \
    nextIrpSp->Control = 0; }

#endif	// (_WIN32_WINNT < 0x0500)

#endif //_pgpDriverNT_h
